package furny.ga.logger;

import furny.ga.FurnLayoutIndividual;
import ga.core.individual.IndividualList;
import ga.core.individual.population.IPopulation;
import ga.core.logging.IGALogger;

import java.util.Date;

/**
 * GA logger that outputs informations to the console (System.out).
 * 
 * @since 11.08.2012
 * @author Stephan Dreyer
 */
public class GAConsoleLogger implements IGALogger<FurnLayoutIndividual> {

  @Override
  public void evaluationStarted() {
    System.out.println("Evaluation started on " + new Date());
  }

  @Override
  public void populationInitiated(final int generation,
      final IPopulation<FurnLayoutIndividual> population) {
    System.out.println("Generation " + generation + ": population initiated: "
        + population);
  }

  @Override
  public void allIndividualsEvaluated(final int generation,
      final IPopulation<FurnLayoutIndividual> population) {
    System.out.println("Generation " + generation
        + ": all individuals evaluated: " + population);
  }

  @Override
  public void individualsSelected(final int generation,
      final IndividualList<FurnLayoutIndividual> list) {
    System.out.println("Generation " + generation + ": individuals selected: "
        + list);
  }

  @Override
  public void individualsCrossed(final int generation,
      final IndividualList<FurnLayoutIndividual> list) {
    System.out.println("Generation " + generation + ": individuals crossed: "
        + list);
  }

  @Override
  public void individualsMutated(final int generation,
      final IndividualList<FurnLayoutIndividual> list) {
    System.out.println("Generation " + generation + ": individuals mutated: "
        + list);
  }

  @Override
  public void individualsInserted(final int generation,
      final IndividualList<FurnLayoutIndividual> list,
      final IPopulation<FurnLayoutIndividual> population) {
    System.out.println("Generation " + generation + ": individuals inserted: "
        + list);
  }

  @Override
  public void individualSelectedForEvaluation(final int generation,
      final FurnLayoutIndividual individual) {
    System.out.println("Generation " + generation
        + ": individual selected for evaluation: " + individual);
  }

  @Override
  public void individualEvaluated(final int generation,
      final FurnLayoutIndividual individual) {
    System.out.println("Generation " + generation + ": individual evaluated: "
        + individual);
  }

  @Override
  public void exit() {
    System.out.println("Logger closed");
  }

}
